#!/usr/bin/env bash

set -e

main() {
    local logins=$(backup_duplicate print-logins)
    for user_robot in ${logins[@]}; do
        local users=$(sed 's/:/ /g' <<< ${user_robot}) # 'user:robot' became 'user robot'
        local login=${users[0]}
        local robot=${users[1]}

        local yesterday=$(date +"%Y-%m-%d" -d "yesterday")
        backup_duplicate duplicate ${login} ${yesterday}  # Handle messages on the boundary of 00:00

        local today=$(date +"%Y-%m-%d")
        backup_duplicate duplicate ${login} ${today}
        compare_mailboxes ${login} ${robot} ${today} corp normal
    done
}

main
