# /mail/send_mail

Ручка для отправки писем от яндексовых пользователей


## Headers

`Content-Type: multipart/mixed` нужен обязательно


## Query args

**Обязательные:**

`uid` id отправителя

`from_email` email отправителя

`service` имя сервиса-клиента. Сервис: "sendbernar"

`detect_spam` проверка письма на спам. Если выставлен в 0 - проверка на спам не проивзодится

`detect_virus` проверка письма на вирусы. Если выставлен в 0 - проверка на вирусы не проивзодится

`request_id` id запроса

**Необязательные:**

`send_type` особый тип отправления. Допустимые значения: "collectors" (для отправки со сборщиков)

**Пример запроса c аргументами:**

```
/mail/send_mail?uid=1&from_email=test%40yandex.ru&service=sendbernar&detect_spam=0&detect_virus=0&request_id=id
```


## Body

**Multipart запрос:**

Тело запроса состоит из двух частей (именно в таком порядке). Хэдер Content-Type нужен обязательно:

1. json параметров
2. тело письма как есть

### Json параметры

**Обязательные:**

`to` список получателей

**Необязательные:**

`сс` получатели, которым придет копия письма

`bcc` получатели из скрытой копии

`lid` список id меток, которые проставятся отправителю

`sender_label` список меток, которые проставятся отправителю

`common_label` список меток, которые проставятся всем получателям (в том числе и отправителю, если он есть среди получателей)

`notify` (string) уведомить отправителя о статусе доставки письма. По умолчанию пустая строка. Значение "1" - означает, что нужно уведомить отправителя

`save_to_sent` (string) сохранить ли письмо отправителю в "Отправленные". По умолчанию пустая строка. Значение "1" - означает, что нужно сохранить письмо отправителю в "Отправленные"

`personal_labels` словарь адресов со списками меток, которые нужно проставить получателю с таким адресом

`ip` адрес отправителя

`host` имя хоста, с которого отправили письмо

**Пример json части запроса:**

```
Content-Type: application/json
MIME-Version: 1.0

{
   "sender_label" : [
      "symbol:seen_label"
   ],
   "bcc" : [],
   "cc" : [],
   "save_to_sent" : "1",
   "lid" : [],
   "ip" : "::1",
   "common_label" : [
      "SystMetkaSO:people"
   ],
   "to" : [
      "amironochev@ya.ru"
   ],
   "personal_labels" : {}
}
```

### Тело письма

**Пример тела письма:**

```
Content-Type: message/rfc822
MIME-Version: 1.0

Subject: Hello

Test
```

## Ответы:

- `200 Ok`

```{"error": "Success", "explanation": "Ok"}```

- `400 Bad request`

- `500 Internal server error`

- `406 Not acceptable`

Попытка отправить спамовое письмо

```{"error": "Spam", "explanation": "..."}```

Попытка отправить malicious спамовое письмо

```{"error": "StrongSpam", "explanation": "...", "ban_reason": "..."}```

Попытка отправить вирусного письмо

```{"error": "Virus", "explanation": "..."}```

Ошибка обработки получателей письма

```{"error": "BadRecipient", "explanation": "..."}```

Ошибка связанная c временным баном и плохой кармой пользователей

```{"error": "BadKarmaBanTime", "explanation": "..."}```

Ошибка попытки отправки письма

```{"error": "SendMessageFailed", "explanation": "..."}```

Ошибка недоступности, связанных с доставкой, компонент

```{"error": "ServiceUnavaliable", "explanation": "..."}```

Ошибка авторизации отправителя письма

```{"error": "FailedToAuthSender", "explanation": "..."}```

Превышение лимита на количество получателей

```{"error": "ToManyRecipients", "explanation": "..."}```

### Причины бана(ban_reason):

- `RfcFail` - в письме некорректные RFC-заголовки

- `UrlRbl` - в письме есть небезопасная ссылка

- `BadKarma` - у аккаунта отправителя плохая карма

- `MailLimits` - достигнут лимит отправок с почтового ящика

- `PddAdminKarma` - для пользователей ПДД плохая карма админа домена

- `Bounces` - отправляемые с этого ящика письма не принимаются внешними почтовыми системами

- `SpamCompl` - получатели считают отправляемые с этого ящика письма спамом
