# /mail/store

Ручка для сохранения писем.

Используется:
1. для реализации команды APPEND протокола IMAP;
2. для приема писем от сборщиков.

## Headers
`X-Request-Id` идентификатор запроса.

`Content-Type: multipart/mixed` нужен обязательно для multipart запроса.

## Query args

**Обязательные:**

`uid` id пользователя кому складывается письмо

`fid` id папки в базе куда складывается письмо, необязателен в случае присутствия параметра `folder_path` в json части запроса

`service` имя сервиса-клиента. Один из: "sendbernar", "imap", "collectors", "iex-proxy".

## Body
**Multipart запрос**. Тело запроса состоит из двух частей (именно в таком порядке): 
1. json
2. тело письма как есть

### Json:

Секция `options`:

`detect_spam` (bool) Проверять на спам. По-умолчанию `false`

`detect_virus` (bool) Проверять на вирусы. По-умолчанию `false`

`detect_loop` (bool) Проверять на циклы. По-умолчанию `false`

`enable_push` (bool) Отсылать пуш. По-умолчанию `false`

`use_filters` (bool) Применять пользовательские фильтры. По-умолчанию `false` 

`allow_duplicates` (bool) Разрешать дубликаты. По-умолчанию `false`. Доступно после MAILDLV-4658

`un_dot_stuffing` (bool) Применять обратный дотстаффинг. По-умолчанию `false`.

Секция `user_info`:

`email` (string) Адрес получателя (нужен для СО). 

Секция `mail_info`:

`folder_path` (string) полный путь папки, куда следует сложить письмо

`folder_spam_path` (string) полный путь папки, куда следует сложить письмо в случае спама

`folder_path_delim` (string) разделитель путей папки

`received_date` (int) дата получения письма

`labels` словарь меток, которые надо проставить на письмо:
- `system` ([string]) массив системных меток
- `symbol` ([string]) массив символьных меток
- `imap` ([string]) массив imap меток
- `lids` ([string]) массив лидов
- `user` ([string]) массив пользовательских меток

`old_mid` (string) `mid` письма, которое по-возможности нужно обновить вместо создания нового письма.

### Пример json части запроса:
```
{
    "options": {
        "detect_spam": false,
        "detect_virus": false,
        "detect_loop": false,
        "enable_push": false,
        "allow_duplicates": false,
        "use_filters": false,
        "un_dot_stuffing": true
    },
    "user_info": {
        "email": "foo@yandex.ru"
    },
    "mail_info": {
        "folder_path": "Inbox",
        "folder_spam_path": "Spam",
        "received_date": 1573795913,
        "labels": {
            "system": ["recent", "seen"],
            "imap": [],
            "symbol": ["important", "append_label"], 
            "lids": []
        }
    }
}
```

## Ответы:

*TODO: MAILDLV-2398 При необходимости расширить интерфейс для поддержания фолбека на обычную отправку*

- `200 Ok`

```{"mid": "123"}```

Если письмо успешно сложилось, а так же если был найден дубликат.

- `400 Bad request`

```{"code": "bad_request", "message": "bad message"}```

- `413 Entity too large`

При превышении ограничения размера тела запроса в ~41MB.
Отлуп дает веб свервер, поэтому формат ответа дефолтный, внутренние обработчики не вызываются.

- `406 Not Acceptable`

```{"code": "rejected_spam", "message": "Rejected under suspicion of spam"}```

```{"code": "rejected_virus", "message": "Rejected under suspicion of virus"}```

- `409 Conflict`

```{"code": "store_error", "message": "Permanent store error"}```

```{"code": "loop_detected", "message": "loop detected"}```

- `500 Internal server error`

```{"code": "internal_server_error", "message": "Internal error"}```

```{"code": "store_error", "message": "Temporary store error"}```

## Основные свойства:
1. Если не существует папки с `fid=<fid>` и нет folder_path, то операция фейлится. С параметром folder_path - создается указанная папка.
2. Нет персонального спама.
3. Дедупликация работает по кортежу (`uid`, `fid`, `from`, `hdr_message_id`, `subject`, `hdr_date`)
4. Выключены DSN нотификации.

## Особенности поведения ручки с параметром old_mid:
Этот параметр передается для оптимизации сохранения письма:
  1. для экономии места в базе
  2. для ускорения операции, т.к. не берется advisory lock, ведь письмо уже существует.

**Когда происходит фолбек на обычное сохранение?**:

Не смотря на наличие этого параметра, в следующих случаях будет создано новое письмо с новым мидом по обычным правилам:
  * в запросе меняются следующие свойства письма:
    - метки
    - fid
    - флаги seen или deleted
    - тема
  * письмо с `uid` + `old_mid` не существует в базе
  * произошла ошибка

Надо иметь ввиду, что в результате фолбека на обычную операцию произойдет проверка на дупликаты. 

**Обход дедупликации в Сендбернаре**:

На момент написания спеки Сендбернар, при последовательных обновлениях писем, перегенерирует `Message-Id` и `Date`. 
В таком случае, дедупликация не срабатывает для писем с old_mid и фолбеком на обычное сохранение (см. выше). 
В то же время при ретраях, например из-за таймаута, в рамках одной покладки проверка на дупликаты выполняется, т.к `Message-Id` и `Date` те же.

Пример: для черновика добавляется аттач. Тогда будет сделан запрос с `old_mid` и к письму добавится метка `attach_label`. Произойдет фолбек на сохранение и выполнится проверка на дупликаты. Если бы не было обхода дедупликации, то обновить письмо не удалось бы. 

Это свойство не очевидно и важно его аккуратно менять.
