#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import requests
import psycopg2
import time
import traceback
import logging
import argparse
import signal
from multiprocessing import Pool

class KeyboardInterruptError(Exception): pass


def resolve_email_to_uid(email):
    login = email[:email.find('@')]
    r = requests.get(PASSPORT_HOST + "blackbox/?method=userinfo&userip=127.0.0.1&login=" + str(login) )
    uid = None
    for row in r.text.split('\n'):
        if '<uid' in row:
            l = row.find('>')
            row = row[l+1:]
            r = row.find('<')
            uid = row[:r]
            break
    return uid


def resolve_email_to_suid(email):
    login = email[:email.find('@')]
    r = requests.get(PASSPORT_HOST + "blackbox/?method=userinfo&userip=127.0.0.1&dbfields=subscription.suid.2&login=" + str(login) )
    suid = None
    for row in r.text.split('\n'):
        if 'subscription.suid.2' in row:
            l = row.find('>')
            row = row[l+1:]
            r = row.find('<')
            suid = row[:r]
            break
    return suid


def handle_pg(email, pctx):
    status = False
    reason = "Not implemented"
    uid = resolve_email_to_uid(email)
    c = pctx.cursor()
    c.execute("""SELECT code.delete_messages(uid, mids) FROM
    (SELECT uid::code.uid uid, array_agg(mid)::code.mids mids FROM mail.box WHERE uid=%s AND NOT lids@>ARRAY[2] GROUP BY uid) x;""" % uid)
    del_results = c.fetchall()
    pctx.commit()
    c.execute("""WITH del_box AS (
    DELETE FROM mail.deleted_box
     WHERE uid = %s
 RETURNING uid, mid
    ),
     del_mbox AS (
    DELETE FROM mail.messages mm
     WHERE (mm.uid, mm.mid) IN (SELECT uid, mid FROM del_box)
 RETURNING st_id
    )
SELECT * FROM del_mbox;""" % uid)
    response = c.fetchall()
    stids = map(lambda x: x[0], response)
    pctx.commit()
    c.close()
    if len(stids) == 0:
        return (True, "Inbox is empty")
    status = True
    reason = "OK, deleted %d" % len(stids)
    sys.stdout.flush()
    return (status, reason)


def handle(email):
    status = True
    reason = "No action"
    time = 0
    try:
        if not hasattr(handle, "pctx"):
            # https://beta.wiki.yandex-team.ru/mail/pg/xdb/
            print "init conn"
            handle.pctx = psycopg2.connect(connect_timeout=3, **DB_ARGS)
    
        if 'devnull' in email:
            status = False
            reason = "skipping " + email
        elif "-pg" in email :
            return handle_pg(email, handle.pctx)
    except psycopg2.Error as exc:
        print "DB ERROR"
        print exc
        traceback.print_exc()
        try:
            handle.pctx.close()
        except Exception:
            pass
        finally:
            if hasattr(handle, "pctx"):
                print "remove worker conn"
                del handle.pctx

    return (status, reason)


def work(addr):
    status, reason = False, "Unknown"
    try:
        status, reason = handle(addr)
    except KeyboardInterrupt:
        # reraise KeyboardInterrupt as inherited from Exception class https://stackoverflow.com/a/2561809/808594
        raise KeyboardInterruptError()
    except Exception, exc:
        traceback.print_exc()
        status = False
        reason = str(exc)
    return (addr, status, reason)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='Mail DB cleaner, expect list of emails for cleaning on stdin')
    parser.add_argument('-w', '--workers', type=int, default=32, help='Cleaning workers count')
    parser.add_argument('--passport', default='http://pass-test.yandex.ru/',
        help='Passport host for uid resolving')
    parser.add_argument('--dsn', help='Connection string for DB with mail metadata')
    parser.add_argument('-d', '--debug', action='store_true')
    args = parser.parse_args()
    global DB_ARGS
    DB_ARGS = dict([a.split('=') for a in args.dsn.split()])
    global PASSPORT_HOST
    PASSPORT_HOST = args.passport

    results = []

    data = []
    for row in sys.stdin:
        _to = row.replace('"','').strip()
        data.append(_to)
    pool = Pool(args.workers)
    try:
        results = pool.map(work, data)
        pool.close()
    except KeyboardInterrupt:
        print "Caught KeyboardInterrupt, terminating workers"
        pool.terminate()
    except Exception, e:
        print 'got exception: %r, terminating the pool' % (e,)
        p.terminate()
        print 'pool is terminated'
    finally:
        pool.join()

    sys.stdout.flush()
    for r in results:
        print r     
