STATUS=0
pwd

MULCA_HOST=mulca-loadtest.mail.yandex.net
MULCAGATE_HOST=mulcagate-loadtest.mail.yandex.net

echo $TASK_URL > task_url.txt

ARCHIVE_DIR=/var/bmpt/f2nd/archive/fastsrv/build_${BUILD_NUMBER}

mkdir ${ARCHIVE_DIR}

DURATION=$(echo $RAMPUP $TIME | awk '{print $1+$2}')

echo "" > letter.txt

#Ключи для пользователя ЛП, нужны, чтобы сходить на мишень за версией и логом профайлера
SSH_OPTS="-A -o LogLevel=Error -o StrictHostKeyChecking=no -o PasswordAuthentication=no -i /var/lib/jenkins/.ssh/id_rsa_tank -l lunapark"
SCP_OPTS="-o LogLevel=Error -o StrictHostKeyChecking=no -o PasswordAuthentication=no -i /var/lib/jenkins/.ssh/id_rsa_tank"

#Запрашиваем версию
NW_VERSION=$( (cat get_ver ; echo get_ver nwsmtp) | ssh ${SSH_OPTS} ${HOST} bash)
FAST_VERSION=$( (cat get_ver ; echo get_ver fastsrv) | ssh ${SSH_OPTS} ${HOST} bash)
POSTFIX_VERSION=$( (cat get_ver ; echo get_ver yamail_postfix) | ssh ${SSH_OPTS} ${HOST} bash)
VERSION=$(echo $FAST_VERSION)
FULL_VERSION=$(echo $NW_VERSION $FAST_VERSION $POSTFIX_VERSION)


CONF_PATH="/etc/fastsrv/fastsrv.yml"
SERVICE="fastsrv"

USERS_DESC=$(echo ${USERS} | sed 's/.*users.//;s/.csv//')

DESCRIPTION="${COMMENT}[${USERS_DESC}][${COMPONENT}][${START}-${END} rps][${THREADS} thr][${VERSION}]"

#echo "BUILD_DESCRIPTION: ${DESCRIPTION}"

echo $VERSION > version.txt

if [[ x"${CLEAN_MAILBOXES,,}" == "xtrue" ]]
then
    awk -F',' '{print $2}' ${USERS} | python clean_inbox.py > inbox_clear_${BUILD_NUMBER}.log
fi

#Очистка pa лога
ssh  ${SSH_OPTS} ${HOST} "printf '' | sudo tee /var/log/fastsrv-profiler.log"

echo "${CONFIG}" | ssh ${SSH_OPTS} ${HOST} "\
    cat > config && \
    sudo rm ${CONF_PATH} && \
    sudo cp ./config ${CONF_PATH} && \
    sudo service ${SERVICE} restart"

for i in 1 2 3 4 5 6 7
do
    code=0 
    sleep 2
    ssh ${SSH_OPTS} ${HOST} "nc -z localhost ${PORT}" || code=$?
        if [[ ${code} -eq 0 ]]
        then
            echo "Try ${i}: Something responde on ${HOST}:${PORT}"; break
        fi
done

if [[ 0 -ne ${code} ]]
then
    echo "ERROR: it seems nobody listen on ${HOST}:${PORT}"
    exit ${code}
fi

#echo "${SESSIONS}" | python sessions.py

JMX=fastsrv.jmx

sed -i "s/__TARGET__/${HOST}/" monitoring_smtp.xml

TANKS="-t mars.tanks -t fobos.tanks"

tankapi-cmd ${TANKS} \
    -f monitoring_smtp.xml \
    -f fastsrv_stat.py \
    -f mulca_stat.py \
    -f fast_db_stat.py \
    -f ${USERS} \
    -f ${JMX} \
    -c /dev/null \
    -o "tank.plugin_phantom=" \
    -o "tank.plugin_jmeter=yandextank.plugins.JMeter" \
    -o "meta.task=${TASK}" \
    -o "meta.notify=${NOTIFY}" \
    -o "meta.ver=${VERSION}" \
    -o "meta.job_name=${DESCRIPTION}" \
    -o "meta.job_dsc=bmpt.tanks:${ARCHIVE_DIR}" \
    -o "meta.jenkinsbuild=${BUILD_URL}" \
    -o "meta.jenkinsjob=${JOB_URL}" \
    -o "meta.lock_targets = ${HOST} ${LOCK_HOSTS}" \
    -o "meta.target_lock_duration = ${DURATION}" \
    -o "meta.warmup = ${RAMPUP}" \
    -o "meta.cooldown = $((RAMPUP+DURATION-5))" \
    -o "meta.multitag=true" \
    -o "meta.component=${COMPONENT}" \
    -o "jmeter.jmx=${JMX}" \
    -o "jmeter.jmeter_path=/home/f2nd/jmeter-3.0/bin/jmeter-large" \
    -o "jmeter.args= -Jjmeter.save.saveservice.autoflush=true -Djava.net.preferIPv6Addresses=true" \
    -o "jmeter.cto = ${CTO}" \
    -o "jmeter.rto = ${RTO}" \
    -o "jmeter.host = ${HOST}" \
    -o "jmeter.port = ${PORT}" \
    -o "jmeter.duration = ${DURATION}" \
    -o "jmeter.time = ${TIME}" \
    -o "jmeter.threads = ${THREADS}" \
    -o "jmeter.rampup = ${RAMPUP}" \
    -o "jmeter.start = ${START}" \
    -o "jmeter.end = ${END}" \
    -o "jmeter.ammo = ${AMMO}" \
    -o "jmeter.users = $(basename ${USERS})" \
    -o "jmeter.buffered_seconds=2" \
    -o "jmeter.ext_log = errors" \
    -o "autostop.autostop = ${AUTOSTOP}" \
    -o "monitoring.config = monitoring_smtp.xml" \
    -o "shellexec.prepare=scp ${SCP_OPTS} fast_db_stat.py fastsrv_stat.py lunapark@${HOST}:/tmp/
    scp ${SCP_OPTS} mulca_stat.py lunapark@${MULCA_HOST}:/tmp/
    scp ${SCP_OPTS} mulca_stat.py lunapark@${MULCAGATE_HOST}:/tmp/" \
    -d "tank*log" \
    -j ./jobno.txt || STATUS=$?


JOBNO=$(tail -1 jobno.txt)
echo $JOBNO > jobno

WEBLINK=$(grep 'Web link' tank*log | tail -n 1 | grep -o 'https[^ ]*')

printf "DESCRIPTION=${DESCRIPTION}\nWEBLINK=${WEBLINK}" > result.env

if [[ ! -z "${UPSTREAM_BUILD}" ]] ; then
    COMPO=${COMPONENT//-/_}
    printf "${COMPO^^}_JOB=$JOBNO\nVERSION=${VERSION}\nCOMPONENT=${COMPONENT}\n" > "/home/f2nd/automation/fastsrv/build_${UPSTREAM_BUILD}_${COMPONENT}.jobno"
fi

ssh -C ${SSH_OPTS} ${HOST} "pa /var/log/fastsrv-profiler.log | gzip -9 -c" > ${ARCHIVE_DIR}/fastsrv-profiler.log.gz

python /home/schizophrenia/lib/pa.py report ${ARCHIVE_DIR}/fastsrv-profiler.log.gz > fastsrv-profiler.table.txt

cat fastsrv-profiler.table.txt
cat fastsrv-profiler.table.txt > "/home/f2nd/automation/fastsrv/build-${UPSTREAM_BUILD}-${COMPONENT}.profiler"

#переопределение кода выхода как успешного, если стрельба была остановлена из веба (8) или сработал автостоп.
case ${STATUS} in
  8|2[1-9]|3[0-2]) STATUS=0 
esac

exit $STATUS
