#!/usr/bin/env/ python2.7

import requests
from requests.exceptions import *
import json
import glob
import sys

regress_map = {
    'nw-mxfront-rps': 2800, 'nw-mxfront-rt': 2801,
    'nw-mxback-rps': 2802, 'nw-mxback-rt': 2803,
    'nw-mxback-out-rps': 2804, 'nw-mxback-out-rt': 2805,
    'nw-smtp-rps': 2806, 'nw-smtp-rt': 2816}

def read_jobno(result_dir, meta_buildno):
    result = {}
    files = glob.glob('%s/build-%s*.jobno' % (result_dir, meta_buildno))
    for f in files:
        with open(f) as props:
            lines = [l.strip() for l in props.readlines()]
            tmp = dict([l.split('=',1) for l in lines])
            result[tmp['compo']] = {'version': tmp['version'], 'jobno':tmp['jobno']}
    return result

def get_cmp_list(regress):
    retry = 3
    jobs = []
    url = 'https://lunapark.yandex-team.ru/api/regress/%d/joblist.json?flag=1&count=4' % regress
    while retry > 0:
        retry -= 1
        try:
            r = requests.get(url, timeout = 10)
            r.raise_for_status()
            jobs = sorted([i['n'] for i in r.json()])
            if jobs:
               return ','.join([str(i) for i in jobs])
        except (ConnectionError, Timeout):
            pass
    raise RetryError("Can't get %s in 3 tries" % url)

def write_results(job_info, cmp_info):
    versions = list(set([v['version'] for k,v in job_info.items()]))
    result = 'VERSION=%s\n' % ', '.join(versions)
    links = sorted(['((https://lunapark.yandex-team.ru/%s %s))' % (v['jobno'], k) for k,v in job_info.items()])
    result += 'LINKS=%s\n' % ' '.join(links)
    cmp_links = []
    for cfg, jobs in cmp_info.items():
        cmp_links.append(u'((https://lunapark.yandex-team.ru/compare/#jobs=%s&tab=test_data&mainjob=%s&helper=all&cases=&plotGroup=additional&metricGroup=&target= %s))' % (jobs+','+job_info[cfg]['jobno'], job_info[cfg]['jobno'], cfg))
    result += 'CMP=%s\n' % ' '.join(cmp_links)
    sys.stdout.write(result)

if __name__ == '__main__':
    result_dir = '/home/f2nd/automation/nwsmtp'
    meta_buildno = sys.argv[1]

    job_info = read_jobno(result_dir, meta_buildno)
    cmp_info = {}
    for cfg in job_info:
        if cfg.endswith('-rt'):
            cmp_info[cfg] = get_cmp_list(regress_map[cfg])

    write_results(job_info, cmp_info)
