STATUS=0
pwd

MULCA_HOST=mulca-loadtest.mail.yandex.net
TASK_URL="https://st.yandex-team.ru/${TASK}"

echo $TASK_URL > task_url.txt

DURATION=$(echo $RAMPUP $TIME | awk '{print $1+$2}')

echo "" > letter.txt

#Ключи для пользователя ЛП, нужны, чтобы сходить на мишень за версией и логом профайлера
SSH_OPTS="-A -o LogLevel=Error -o StrictHostKeyChecking=no -o PasswordAuthentication=no -i /var/lib/jenkins/.ssh/id_rsa_tank -l lunapark"
SCP_OPTS="-o LogLevel=Error -o StrictHostKeyChecking=no -o PasswordAuthentication=no -i /var/lib/jenkins/.ssh/id_rsa_tank"

#Запрашиваем версию
NW_VERSION=$( (cat get_ver ; echo get_ver nwsmtp) | ssh ${SSH_OPTS} ${HOST} bash)
FAST_VERSION=$( (cat get_ver ; echo get_ver fastsrv) | ssh ${SSH_OPTS} ${HOST} bash)
POSTFIX_VERSION=$( (cat get_ver ; echo get_ver yamail_postfix) | ssh ${SSH_OPTS} ${HOST} bash)
FULL_VERSION=$(echo $NW_VERSION $FAST_VERSION $POSTFIX_VERSION)


if [[ x"${NW_OUT,,}" == "xtrue" ]]
then 
    CONF_PATH="/etc/nwsmtp/config-out.yml"
    SERVICE="nwsmtp-out"
else
    CONF_PATH="/etc/nwsmtp/config.yml"
    SERVICE="nwsmtp"
fi

USERS_DESC=$(echo ${USERS} | sed 's/.*users.//;s/.csv//')

DESCRIPTION="$COMMENT[${USERS_DESC}][${COMPONENT}][${START}-${END} rps][${THREADS} thr][${NW_VERSION}]"

echo "BUILD_DESCRIPTION: ${DESCRIPTION}"

echo $NW_VERSION > version.txt

if [[ x"${CLEAN_MAILBOXES,,}" == "xtrue" ]]
then
    DSN="host=$DBHOST port=6432 dbname=maildb user=mxback password=$DBPASS"
    cat ${USERS} | python clean_inbox.py --dsn "$DSN" > inbox_clear_${BUILD_NUMBER}.log
fi

#Очистка лога
ssh  ${SSH_OPTS} ${HOST} "printf '' | sudo tee /var/log/nwsmtp-profiler.log"

echo "${CONFIG}" | ssh ${SSH_OPTS} ${HOST} "\
    cat > config && \
    sudo rm ${CONF_PATH} && \
    sudo cp ./config ${CONF_PATH} && \
    sudo service ${SERVICE} restart"

for i in $(seq 15)
do
    code=0 
    sleep 2
    if [[ ${PORT} -eq 465 ]]
    then
        ssh ${SSH_OPTS} ${HOST} "ss -tlpn | grep ${PORT} | uniq" || code=$?
    else
        ssh ${SSH_OPTS} ${HOST} "nc -z localhost ${PORT}" || code=$?
    fi
    if [[ ${code} -eq 0 ]]
    then
        echo "Try ${i}: Something responde on ${HOST}:${PORT}"; break
    fi
done

if [[ 0 -ne ${code} ]]
then
    echo "ERROR: it seems nobody listen on ${HOST}:${PORT}"
    exit ${code}
fi

echo "${SESSIONS}" | python sessions.py

V6_HOST=$(host -t AAAA smtp-loadtest1p.mail.yandex.net | awk '{print "[" $NF "]"}')

sed -i "s/__TARGET__/${HOST}/" monitoring_nw.xml

TANKS=" -t mars.tanks -t fobos.tanks "

tankapi-cmd ${TANKS} -c /dev/null \
    -f monitoring_nw.xml \
    -f nw_av_stat.py \
    -f sessions \
    -f YandexInternalCA.keystore \
    -f ${USERS} \
    -f ${JMX} \
    \
    -o "meta.jenkinsbuild=${BUILD_URL}" \
    -o "meta.jenkinsjob=${JOB_URL}" \
    -o "meta.task=${TASK}" \
    -o "meta.notify=${NOTIFY}" \
    -o "meta.operator = ${OPERATOR}" \
    -o "meta.ver=${NW_VERSION}" \
    -o "meta.job_name=${DESCRIPTION}" \
    -o "meta.job_dsc=${FULL_VERSION} bmpt.tanks:${ARCHIVE_DIR} \n config override:\n ${CONFIG}" \
    -o "meta.lock_targets = ${HOST} ${LOCK_HOSTS}" \
    -o "meta.target_lock_duration = ${DURATION}" \
    -o "meta.jobno_file = jobno_file.txt" \
    -o "meta.component = ${COMPONENT}" \
    \
    -o "tank.plugin_phantom=" \
    -o "tank.plugin_jmeter = yandextank.plugins.JMeter" \
    \
    -o "jmeter.jmx=${JMX}" \
    -o "jmeter.jmeter_path=/home/f2nd/jmeter-4.0/bin/jmeter-large" \
    -o "jmeter.args= -Djavax.net.ssl.trustStore=YandexInternalCA.keystore -Djava.net.preferIPv6Addresses=true" \
    -o "jmeter.buffer_size = 2" \
    -o "jmeter.cto = ${CTO}" \
    -o "jmeter.rto = ${RTO}" \
    -o "jmeter.host = ${V6_HOST}" \
    -o "jmeter.port = ${PORT}" \
    -o "jmeter.duration = ${DURATION}" \
    -o "jmeter.time = ${TIME}" \
    -o "jmeter.threads = ${THREADS}" \
    -o "jmeter.rampup = ${RAMPUP}" \
    -o "jmeter.start = ${START}" \
    -o "jmeter.end = ${END}" \
    -o "jmeter.ssl = ${SSL}" \
    -o "jmeter.protocol = ${PROTOCOL}" \
    -o "jmeter.auth = ${AUTH}" \
    -o "jmeter.ammo = ${AMMO}" \
    -o "jmeter.users = $(basename ${USERS})" \
    -o "jmeter.sessions = sessions" \
    -o "jmeter.delay = ${DELAY}" \
    \
    -o "autostop.autostop=${AUTOSTOP}" \
    \
    -o "monitoring.config = monitoring_nw.xml" \
    -o "shellexec.prepare=scp ${SCP_OPTS} nw_av_stat.py lunapark@${HOST}:/tmp/" \
    -j ./jobno.txt | tee tankapi-cmd.log || STATUS=$?

JOBNO=$(tail -1 jobno.txt)

echo $JOBNO > jobno

WEBLINK="http://lunapark.yandex-team.ru/${JOBNO}"

printf "DESCRIPTION=${DESCRIPTION}\nWEBLINK=${WEBLINK}" > result.env

printf "compo=${COMPONENT}\njobno=${JOBNO}\nversion=${NW_VERSION}\n" > /home/f2nd/automation/nwsmtp/build-${UPSTREAM_BUILD}-${COMPONENT}.jobno

#переопределение кода выхода как успешного, если стрельба была остановлена из веба (8) или сработал автостоп.
case ${STATUS} in
  8|2[1-9]|3[0-2]) STATUS=0 
esac

exit $STATUS
