# -*- coding: utf-8 -*-

import json
import logging
from optparse import OptionParser

import requests
from requests.packages.urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(InsecureRequestWarning)


# create logger
logger = logging.getLogger('sender.log')
ch = logging.StreamHandler()
ch.setLevel(logging.DEBUG)
logger.addHandler(ch)

class ProtoStClient(object):

    def __init__(self, oauth_token):
        self.url = 'https://st-api.yandex-team.ru/v2/'
        self.token = oauth_token

        self.session = requests.Session()
        self.session.headers['Authorization'] = 'OAuth {}'.format(self.token)
        self.session.headers['Content-Type'] = 'application/json'

    def add_comment(self, issue, text):
        url = '{base_url}issues/{issue}/comments'.format(base_url=self.url,
                                                         issue=issue)
        data = {'text': text}

        try:
            request = self.session.post(url, json.dumps(data), verify=False)
            if request.ok:
                response = request.json()
                return response.get('id')
            else:
                logger.info('Error on adding comment to %s task', issue)
                logger.info(request.json())
        except Exception as err:
            logger.error('Error writing comment to %s task', issue)
            logger.error('Details: %s', err)

    def create_task(self, issue_dict):
        url = '{base_url}issues'.format(base_url=self.url)
        try:
            request = self.session.post(url, json.dumps(issue_dict), verify=False)
            if request.ok:
                response = request.json()
                return response.get('key')
            else:
                logger.error('Error on creating task in %s', issue_dict.get('queue'))
                logger.error(request.json())
        except Exception as err:
            logger.error('Error creating startrek task')
            logger.error('Details: %s', err)


def parse_options():
    parser = OptionParser()
    parser.add_option("-t", "--task", dest="task", help="task id", default=None, type=str)
    parser.add_option("-c", "--comment", dest="comment", help="Text of comment")
    (opts, _) = parser.parse_args()
    return opts


if __name__ == '__main__':
    options = parse_options()
    with open('/var/bmpt/lunapark/oauth_startrek.token', 'r') as password:
        token = password.read().rstrip()
    client = ProtoStClient(oauth_token=token)

    if options.comment and options.task:
        client.add_comment(issue=options.task, text=options.comment)
    else:
        logger.error(
            'It\'s impossible to post comment without ticket id and comment text.\n'
            'Usage: python sender.py -t ticket -c comment'
        )
