#!/usr/bin/env python2

import sys
import random
import string
import argparse


def parse_sessions():
    result = []
    for line in iter(sys.stdin.readline, ''):
        fields = line.rstrip().split(',')
        tag = fields[0]
        length = int(fields[1])
        count = int(fields[2])
        result += [(tag, length)] * count
    return result

def save(lst, out_file):
    with open(out_file, "wb") as f:
        for tag,length in lst:
            f.write("%s,%d\n" % (tag,length))

if __name__ == '__main__':
    out_file = 'sessions'
    
    sessions = parse_sessions()
    random.shuffle(sessions)
    save(sessions, out_file)
