TASK_URL="https://st.yandex-team.ru/${TASK}"

STATUS=0
CTIMEOUT=5000
RTIMEOUT=20000

#CTIMEOUT=1000
#STIMEOUT=5000
pwd

echo $TASK_URL > task_url.txt

DURATION=$(echo $RAMPUP $TIME | awk '{print $1+$2}')

echo "" > letter.txt

#Ключи для пользователя ЛП, нужны, чтобы сходить на мишень за версией
SSH_OPTS="-A -o StrictHostKeyChecking=no -o PasswordAuthentication=no -i /var/lib/jenkins/.ssh/id_rsa_tank -l lunapark"
SCP_OPTS="-o StrictHostKeyChecking=no -o PasswordAuthentication=no -i /var/lib/jenkins/.ssh/id_rsa_tank"

#Запрашиваем версию
#NWSMTP_VERSION=$( (cat get_ver ; echo get_ver nwsmtp) | ssh ${SSH_OPTS} ${HOST} bash)
FASTSRV_VERSION=$( (cat get_ver ; echo get_ver fastsrv) | ssh ${SSH_OPTS} ${HOST} bash)
VERSION=$( (cat get_ver ; echo get_ver smtpgate) | ssh ${SSH_OPTS} ${HOST} bash)

#Очистка pa лога
#ssh  ${SSH_OPTS} ${HOST} "sudo sh /home/lunapark/clean_pa.sh"

USERS_DESC=$(echo ${USERS} | sed 's/gate_users.//;s/.csv//')

DESCRIPTION="${SUFFIX}[${USERS_DESC}, ${HANDLERS}][${START}-${END} rps][${VERSION} ${FASTSRV_VERSION}]"

echo "BUILD_DESCRIPTION: ${DESCRIPTION}"

echo $VERSION > version.txt

if [[ x"${CLEAN_MAILBOXES,,}" == "xtrue" ]]
then
    awk -F',' '{print $2}' ${USERS} | python clean_inbox.py > inbox_clear_${BUILD_NUMBER}.log
fi

echo "${MON}" > monitoring_gate.xml

sed -i "s/__TARGET__/${HOST}/" monitoring_gate.xml

tankapi-cmd -t fobos.tanks -t mars.tanks \
    -f monitoring_gate.xml \
    -f fast_db_stat.py \
    -f fastsrv_stat.py \
    -f av_stat.awk \
    -f gate_mailish_users \
    -f mulca_stat.py \
    -f ${USERS} \
    -f ${HANDLERS} \
    -f smtpgate.jmx \
    -c /dev/null \
    -o "tank.plugin_phantom=" \
    -o "tank.plugin_jmeter = yandextank.plugins.JMeter" \
    \
    -o "meta.task=${TASK}" \
    -o "meta.notify=${NOTIFY}" \
    -o "meta.ver=${VERSION}" \
    -o "meta.job_name=${DESCRIPTION}" \
    -o "meta.job_dsc=bmpt.tanks:${ARCHIVE_DIR}" \
    -o "meta.jenkinsbuild=${BUILD_URL}" \
    -o "meta.jenkinsjob=${JOB_URL}" \
    -o "meta.lock_targets = ${HOST} ${LOCK_HOSTS}" \
    -o "meta.target_lock_duration = ${DURATION}" \
    -o "meta.api_timeout = 90" \
    \
    -o "jmeter.jmx=smtpgate.jmx" \
    -o "jmeter.jmeter_path=/home/f2nd/jmeter-3.0/bin/jmeter-large" \
    -o "jmeter.args = -Djava.net.preferIPv6Addresses=true" \
    -o "jmeter.buffered_seconds=2" \
    -o "jmeter.threads=${THREADS}" \
    -o "jmeter.rampup=${RAMPUP}" \
    -o "jmeter.cto=${CTIMEOUT}" \
    -o "jmeter.rto=${RTIMEOUT}" \
    -o "jmeter.time=${TIME}" \
    -o "jmeter.start=${START}" \
    -o "jmeter.end=${END}" \
    -o "jmeter.host=${HOST}" \
    -o "jmeter.port=${PORT}" \
    -o "jmeter.protocol=${PROTOCOL}" \
    -o "jmeter.users=${USERS}" \
    -o "jmeter.handlers=${HANDLERS}" \
    -o "jmeter.ammo=${AMMO}" \
    \
    -o "telegraf.config=monitoring_gate.xml" \
    -o "shellexec.prepare=scp ${SCP_OPTS} fast_db_stat.py fastsrv_stat.py lunapark@${HOST}:/tmp/" \
    -j ./jobno.txt || STATUS=$?

tail -1 jobno.txt > rt.jobno

JOBNO=$(tail -1 jobno.txt)

WEBLINK="http://lunapark.yandex-team.ru/${JOBNO}"

printf "DESCRIPTION=${DESCRIPTION}\nWEBLINK=${WEBLINK}" > result.env

#ssh -C ${SSH_OPTS} ${HOST} "pa /var/log/fastsrv-profiler.log | gzip -9 -c" > ${ARCHIVE_DIR}/fastsrv-profiler.log.gz

#python /home/schizophrenia/lib/pa.py report ${ARCHIVE_DIR}/fastsrv-profiler.log.gz > fastsrv-profiler.table.txt

case ${STATUS} in
  #8|2[1-9]|3[0-2]) STATUS=0 
  8) STATUS=0
esac

exit $STATUS
