#!/bin/bash

source /usr/lib/qloud-mail-mx.sh

groupadd -r nwsmtp
useradd -r -d /var/run/nwsmtp/ -s /sbin/nologin -c 'NwSMTP' -g nwsmtp nwsmtp

[[ -z ${CONFIG_NAME} ]] && CONFIG_NAME=nwsmtp.yml-$QLOUD_COMPONENT"-"$QLOUD_ENVIRONMENT

ln -svf /etc/nwsmtp/$CONFIG_NAME /etc/nwsmtp/config.yml

ln -sf /etc/nwsmtp/push-client/push-client-nwsmtp-log.yaml-${QLOUD_COMPONENT} /etc/push-client/push-client-nwsmtp-log.yaml

qloud_link /var/log/nwsmtp nwsmtp:nwsmtp

touch /var/log/nwsmtp/yplatform.log
touch /var/log/nwsmtp/http_client.tskv
touch /var/log/nwsmtp/http_client-out.tskv
touch /var/log/nwsmtp/nwsmtp.tskv
touch /var/log/nwsmtp/nwsmtp-out.tskv
touch /var/log/nwsmtp/nwsmtp_analytics.tskv
touch /var/log/nwsmtp/nwsmtp_analytics-out.tskv
touch /var/log/nwsmtp/access.tskv

chown -HR nwsmtp:nwsmtp /var/log/nwsmtp

chmod 644 /var/log/nwsmtp/*


# Инициализация domain_maps:
if [ -f "/etc/yandex/domain_maps/configs/maps.conf.${QLOUD_COMPONENT}" ]; then
    ln -svf /etc/yandex/domain_maps/configs/maps.conf.${QLOUD_COMPONENT} /etc/yandex/domain_maps/maps.conf

    chmod 644 /etc/yandex/domain_maps/get-domain-maps.cron
    ln -svf /etc/yandex/domain_maps/get-domain-maps.cron /etc/cron.d/get-domain-maps

    /usr/sbin/get-domain-maps
fi

ln -svf /usr/share/monitor/config/$QLOUD_COMPONENT.conf /etc/monrun/conf.d/$QLOUD_COMPONENT.conf

# Распаковываем DKIM-ключи, если имеются:
if [ -f /etc/nwsmtp/dkim-keys.tar.gz ];then
    tar xzvf /etc/nwsmtp/dkim-keys.tar.gz -C /
fi

# make 10 attemps in case of any problems
for srv in $(echo "dict.dict queryrec.dict queryrec.weights"); do
    for i in {1..10}; do
        if [[ -f "/usr/share/recognizer/$srv" ]]; then
            echo "ok"
            break
        else
            echo "No $srv found, sleeping"
            sleep 5
        fi
    done

    if [[ "$i" -eq 10 ]]; then
        echo "Failed to find $srv, cannot start"
        exit 1
    fi
done

# Инициализация nwsmtp-out:
if [ ! -z ${CONFIG_OUT_NAME} ];then
    ln -svf /etc/supervisor/conf-available/nwsmtp-out.conf /etc/supervisor/conf.d/
    ln -svf /etc/nwsmtp/$CONFIG_OUT_NAME /etc/nwsmtp/config-out.yml
fi

# Настройка virtual-alias-maps:
if [ -v VIRTUAL_ALIAS_MAPS ] && [ $VIRTUAL_ALIAS_MAPS -eq 1 ];then
    ln -svf /etc/yandex/sorm-aliases/get-sorm-aliases.cron /etc/cron.d/get-sorm-aliases
    chmod 644 /etc/yandex/sorm-aliases/get-sorm-aliases.cron
    /usr/sbin/get-sorm-aliases.sh
fi

# Настройка ipblocker:
if [ -v IPBLOCKER ] && [ $IPBLOCKER -eq 1 ];then
    ln -svf /etc/supervisor/conf-available/ipblocker.conf /etc/supervisor/conf.d/
fi

# Настройка safely_delete_stids:
if [ ! -z ${SAFELY_DELETE_STIDS} ];then
    ln -svf /etc/cron.yandex/safely_delete_stids."$QLOUD_APPLICATION".sh /etc/cron.yandex/safely_delete_stids.sh
else
    rm -rfv /etc/cron.d/safely_delete_stids
fi

# Setup yamail-mx-monitor:
# TODO(MAILDLV-2931) Replace this copy-paste from updater.py with library function
pkg=$(set -- /tmp/yamail-mx-monitor/yamail-mx-monitor*.deb && echo $1)
if [ -f "${pkg}" ]; then
    dpkg-deb --extract ${pkg} / && \
    dpkg-deb --control ${pkg} /tmp/yamail-mx-monitor && \
    bash /tmp/yamail-mx-monitor/postinst
fi

# Настройка тунелей для балансеров:
if [ ! -z ${IPv4_TUN_IPS} ];then
    /usr/bin/production-tun.sh $IPv4_TUN_IPS
fi

app=nwsmtp

exec "$@"
