#pragma once

#include <yplatform/ptree.h>

#include <list>
#include <memory>
#include <mutex>
#include <set>
#include <shared_mutex>
#include <string>
#include <unordered_map>
#include <vector>

namespace NNwSmtp {

class TAliases {
public:
    using TEmails = std::vector<std::string>;
    using TEmailsPtr = std::shared_ptr<TEmails>;

    void Init(const yplatform::ptree& conf);
    void Reload(const yplatform::ptree& conf);

    bool Contains(const std::string& email) const;
    TEmailsPtr Get(const std::string& email) const;

private:
    using TReadLock = std::shared_lock<std::shared_timed_mutex>;
    using TWriteLock = std::unique_lock<std::shared_timed_mutex>;
    using TAliasesMap = std::unordered_map<std::string, TEmailsPtr>;

    void Load(const std::string& filename, TAliasesMap& emailsMap) const;
    void AddAlias(const std::string& key, std::list<std::string> emails, TAliasesMap& map) const;

private:
    TAliasesMap Aliases;
    mutable std::shared_timed_mutex Mutex;
    std::set<std::string> YaHosts;
};

extern TAliases gAliases;

void GlobalLoadAliases(const yplatform::ptree& pt);

}   // namespace NNwSmtp
