#pragma once

#include "interface.h"

#include <boost/variant.hpp>

namespace NNwSmtp::NAuth {

namespace AuthMethods = ymod_smtpserver::commands::AuthMethods;

class TAuthCredentialsExtractorImpl :
    public boost::static_visitor<TAuthResponse>,
    public IAuthCredentialsExtractor
{
public:
    TAuthResponse operator()(const AuthMethods::Login&, const std::string& input);

    TAuthResponse operator()(const AuthMethods::Plain&, const std::string& input);

    TAuthResponse operator()(const AuthMethods::XOAuth2&, const std::string& input);

    TAuthResponse operator()(const AuthMethods::NotSupported&, const std::string&);

    void SetMethod(AuthMethod method) override;

    TAuthCredentials GetData() override;

    std::string GetMethod() override;

    void Reset() override;

    TAuthResponse Consume(const std::string& input) override;

private:
    TAuthCredentials Data;
};

}   // namespace NNwSmtp::NAuth
