#pragma once

#include "types.h"

#include <memory>

namespace NNwSmtp::NAuth {

struct IAuthCredentialsExtractor {
    virtual ~IAuthCredentialsExtractor() = default;

    virtual void Reset() = 0;
    virtual void SetMethod(AuthMethod method) = 0;
    virtual std::string GetMethod() = 0;
    virtual TAuthResponse Consume(const std::string& userInput) = 0;
    virtual TAuthCredentials GetData() = 0;
};

using TAuthCredentialsExtractorPtr = std::shared_ptr<IAuthCredentialsExtractor>;

}   // namespace NNwSmtp::NAuth
