#include "utils.h"

#include <nwsmtp/decoder/mimedecoder.h>

#include <sstream>

namespace NNwSmtp::NAuth {

void extract_base64_str(const std::string &_src, std::string &_dst)
{
    std::istringstream encoded(_src);
    std::ostringstream plain;
    CMimeDecoder().decode_short('b', encoded, plain);
    _dst = plain.str();
}

bool extract_user_password(const std::string &_src, std::string &_user, std::string &_password)
{
    std::string decoded;

    extract_base64_str(_src, decoded);

    std::string::size_type first_pos = decoded.find('\0');

    if (first_pos != std::string::npos)
    {
        std::string::size_type second_pos = decoded.find('\0', first_pos + 1);

        if (second_pos != std::string::npos)
        {
            _user = decoded.substr(first_pos + 1, second_pos - first_pos - 1);
            _password = decoded.substr(second_pos + 1);                         // user and password, no extra steps

            return true;
        }
        else
        {
            _user = decoded.substr(second_pos + 1);
            _password.clear();                                  // only user no password need second SASL step
            return true;
        }

    }
    else                // no start \0 fail
    {
        return false;
    }

}

bool extract_user_token(const std::string& src, std::string& user,
    std::string& token)
{
    std::string decoded;
    extract_base64_str(src, decoded);

    user.clear();
    token.clear();

    std::string user_prefix("user=");
    std::string token_prefix("auth=Bearer ");

    //extract user
    std::string::size_type pos = decoded.find('\1');
    if (pos == std::string::npos)
        return false;
    if (decoded.compare(0, user_prefix.length(), user_prefix) != 0)
        return false;
    user = decoded.substr(user_prefix.length(), pos - user_prefix.length());

    decoded = decoded.substr(pos + 1);

    //extract oauth token
    pos = decoded.find("\1\1");
    if (pos == std::string::npos)
        return false;
    if (decoded.compare(0, token_prefix.length(), token_prefix) != 0)
        return false;
    token = decoded.substr(token_prefix.length(), pos - token_prefix.length());

    return true;
}

}
