#include "client_impl.h"

#include <mail/nwsmtp/src/log.h>

#include <mail/yplatform/include/yplatform/net/buffer_sequence.h>

namespace NNwSmtp::NAvir {

namespace {

TCallback WrapHandler(TCallback&& callback, boost::asio::io_context& io) {
    return [ex = io.get_executor(), handler = std::move(callback)] (auto ec, auto response) mutable {
        boost::asio::post(ex, std::bind(std::move(handler), std::move(ec), std::move(response)));
    };
}

} // namespace anonymous

void TAvirCheckClient::Check(TContextPtr context, TBuffer message, TCallback callback) {
    yplatform::net::zcopy_list<yplatform::net::buffers::const_chunk_buffer> buffers;
    yplatform::net::buffers::insert_chunks_2_queue (
        message.begin_fragment (),
        message.end_fragment (),
        message.head(),
        message.tail(),
        buffers
    );

    Client->check(
        WrapHandler(std::move(callback), Io),
        [context = context] (auto message) {
            NWLOG_CTX(notice, context, "AVIR", message);
        },
        make_writable_buffers_ptr<avir_client::socket>(buffers), message.size()
    );
}

} // namespace NNwSmtp::NAvir
