#pragma once

#include "client.h"

#include <mail/sova/include/nwsmtp/avir_client.h>

#include <boost/asio.hpp>

#include <memory>

namespace NNwSmtp::NAvir {

struct TAvirCheckClient: IAvirCheckClient {
    using TClientPtr = std::shared_ptr<avir_client>;

    TAvirCheckClient(TClientPtr client, boost::asio::io_context& io)
        : Client(std::move(client))
        , Io(io) {}

    void Check(TContextPtr context, TBuffer message, TCallback callback) override;

private:
    TClientPtr Client;
    boost::asio::io_context& Io;
};

} // namespace NNwSmtp::NAvir
