#pragma once

#include <ctime>
#include <optional>
#include <string>

namespace NNwSmtp {

struct TBlackBoxResult {
    std::uint64_t Suid = 0;
    std::int32_t Karma = 0;
    std::int32_t KarmaStatus = 0;
    std::time_t TimeStamp = 0;
    std::time_t RegistrationDate = 0;
    std::string Login;
    std::string AuthAddr;
    std::string Country;
    std::string Uid;
    std::string DefaultEmail;
    std::string Domain;
    std::string Db;
    std::string OrgId;
    bool PhoneConfirmed = false;
    bool IsHosted = false;
    bool IsMaillist = false;
    bool IsCorpList = false;
    bool CatchAll = false;
    bool AppPasswordEnabled = false;
};

using TBlackBoxResultOpt = std::optional<TBlackBoxResult>;

} // namespace NNwSmtp
