#pragma once

#include "client.h"
#include "types.h"

#include <mail/nwsmtp/src/context.h>

namespace NNwSmtp::NBigML {

class TClient: public IClient {
public:
    TClient(
        TConfig config,
        THttpClientPtr httpClient,
        boost::asio::io_context& io
    )
        : Config(std::move(config))
        , HttpClient(std::move(httpClient))
        , Io(io)
    {}

    void Run(TContextPtr, TRequest, TCallback) override;

private:
    static void Handler(TCallback, TRequest, TContextPtr,
        TErrorCode, yhttp::response);

    TConfig Config;
    THttpClientPtr HttpClient;
    boost::asio::io_context& Io;
};

} // namespace NNwSmtp::NBigML
