#include "errors.h"

namespace NNwSmtp::NBigML {

boost::system::error_code FromHttpStatus(int httpStatus) {
    switch (httpStatus) {
    case 200:
        return {};
    case 400:
        return EC_BAD_REQUEST;
    case 403:
        return EC_PERMISSION_DENIED;
    case 404:
        return EC_NOT_FOUND;
    case 500:
        return EC_SERVER_ERROR;
    default:
        return EC_UNKNOWN_STATUS;
    }
}

class TErrorCategory : public boost::system::error_category {
public:
    const char* name() const noexcept override {
        return "Big ML client";
    }

    std::string message(int ev) const override {
        switch (ev) {
        case EC_EXCEPTION:
            return "Exception occurred while performing request";
        case EC_BAD_REQUEST:
            return "Bad request";
        case EC_PERMISSION_DENIED:
            return "Permission denied";
        case EC_NOT_FOUND:
            return "Not found";
        case EC_SERVER_ERROR:
            return "Server error";
        case EC_UNKNOWN_STATUS:
            return "Unknown status";
        default:
            return "Unknown error";
        }
    }
};

const TErrorCategory errorCategory{};

boost::system::error_code make_error_code(EErrorCode code) {
    return {code, errorCategory};
}

}  // namespace NNwSmtp::NBigML
