#pragma once

#include <boost/system/error_code.hpp>

namespace NNwSmtp::NBigML {

enum EErrorCode {
    EC_EXCEPTION = 1,
    EC_BAD_REQUEST,
    EC_PERMISSION_DENIED,
    EC_NOT_FOUND,
    EC_SERVER_ERROR,
    EC_UNKNOWN_STATUS
};

boost::system::error_code FromHttpStatus(int httpStatus);

boost::system::error_code make_error_code(EErrorCode code);

}  // namespace NNwSmtp::NBigML

namespace boost {
namespace system {

template <>
struct is_error_code_enum<NNwSmtp::NBigML::EErrorCode> : std::true_type{};

}  // namespace system
}  // namespace boost
