#pragma once

#include "response.h"

#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/types.h>
#include <mail/nwsmtp/src/auth.h>

#include <memory>

namespace NNwSmtp::NBlackBox {

struct IBBChecks {

    using TCallback = std::function<void(TErrorCode, TResponse)>;

    virtual ~IBBChecks() = default;
    virtual void CheckRecipient(TContextPtr, std::string, std::string, bool, bool, TCallback) = 0;
    virtual void CheckMailFrom(TContextPtr, std::string, std::string, TCallback) = 0;
    virtual void CheckAuth(TContextPtr, TAuthData authInfo, TCallback) = 0;
};

using TBBChecksPtr = std::shared_ptr<IBBChecks>;

} // namespace NNwSmtp::NBlackBox
