#pragma once

#include "bb_checks.h"
#include "bb_client.h"
#include "config.h"

#include <mail/nwsmtp/src/types.h>

#include <functional>

namespace NNwSmtp::NBlackBox {

class TBBChecksImpl: public IBBChecks {
public:
    TBBChecksImpl(TConfigPtr config, NClient::TBBClientPtr client);

    void CheckRecipient(
        TContextPtr context,
        std::string email,
        std::string ip,
        bool allowList,
        bool getOrgId,
        TCallback handler
    ) final;

    void CheckMailFrom(
        TContextPtr context,
        std::string email,
        std::string ip,
        TCallback callBack
    ) final;

    void CheckAuth(
        TContextPtr context,
        TAuthData authInfo,
        TCallback handler
    ) final;

private:
    static void CheckRecipientHandler(
        TConfigPtr config,
        TCallback callBack,
        TErrorCode ec,
        TResponse response
    );

    static void CheckMailFromHandler(
        TConfigPtr config,
        TCallback callBack,
        TErrorCode ec,
        TResponse response
    );

    static void CheckAuthHandler(
        TConfigPtr config,
        bool oauth,
        TCallback callBack,
        TErrorCode ec,
        TResponse response
    );

    TConfigPtr Config;
    NClient::TBBClientPtr Client;

    constexpr static std::int32_t GOOD_KARMA_THRESHOLD = 85;
    constexpr static std::int32_t BAD_KARMA = 100;
};

} // namespace NNwSmtp::NBlackBox
