#pragma once

#include "client_types.h"
#include "response.h"

#include <mail/nwsmtp/src/context.h>

#include <memory>

namespace NNwSmtp::NBlackBox::NClient {

struct IBBClient {
    using TResponseCallback = TCallback<TResponse>;

    virtual ~IBBClient() = default;

    virtual void UserInfo(TContextPtr, THttpRequest, TResponseCallback) = 0;
    virtual void Login(TContextPtr, THttpRequest, TResponseCallback) = 0;
    virtual void Oauth(TContextPtr, THttpRequest, TResponseCallback) = 0;
};

using TBBClientPtr = std::shared_ptr<IBBClient>;

} // namespace NNwSmtp::NBlackBox::NClient
