#pragma once

#include "bb_client.h"

#include <mail/nwsmtp/src/utils.h>
#include <mail/ymod_httpclient/include/ymod_httpclient/cluster_client.h>

namespace NNwSmtp::NBlackBox::NClient {

yhttp::request MakeRequest(THttpRequest request, std::string tvmServiceTicket);

class TClientImpl: public IBBClient {
public:
    using THttpClient = std::shared_ptr<ymod_httpclient::cluster_call>;
    using TTvm2Module = std::shared_ptr<ymod_tvm::tvm2_module>;

    TClientImpl(THttpClient httpClient, TTvm2Module tvm2Module, boost::asio::io_context& io);

    void UserInfo(TContextPtr context, THttpRequest request, TResponseCallback callback) override;
    void Login(TContextPtr context, THttpRequest request, TResponseCallback callback) override;
    void Oauth(TContextPtr context, THttpRequest request, TResponseCallback callback) override;

private:
    THttpClient HttpClient;
    TTvm2Module Tvm2Module;
    boost::asio::io_context& Io;
};

} // namespace NNwSmtp::NBlackBox::NClient
