#pragma once

#include <mail/nwsmtp/src/types.h>

#include <functional>
#include <optional>
#include <string>
#include <unordered_map>
#include <vector>

namespace NNwSmtp::NBlackBox::NClient {

struct THttpRequest {
    std::string Url;
    std::string Body;
};

struct TStatus {
    std::uint32_t Id;
    std::string Value;
};

struct TCommonResponse {
    std::optional<TStatus> Exception;
    std::optional<std::string> Error;
};

struct TAddress {
    std::string Address;
};

namespace NAttributes {

inline const std::string IsMailList = "13";
inline const std::string AppPasswordEnabled = "107";
inline const std::string IsAssessor = "189";
inline const std::string OrgId = "1031";

} // namespace NAttributes

namespace NDbFields {

inline const std::string Suid = "subscription.suid.-";
inline const std::string Suid2 = "subscription.suid.2";
inline const std::string Login = "subscription.login.-";
inline const std::string Login2 = "subscription.login.2";
inline const std::string Country = "account_info.country.uid";
inline const std::string PhoneConfirmedUid = "userphones.confirmed.uid";
inline const std::string Suid102 = "subscription.suid.102";
inline const std::string Suid1000 = "subscription.suid.1000";
inline const std::string LoginRule2 = "subscription.login_rule.2";
inline const std::string LoginRule8 = "subscription.login_rule.8";
inline const std::string RegDate = "account_info.reg_date.uid";
inline const std::string BornDate = "subscription.born_date.2";
inline const std::string Mdb = "hosts.db_id.-";

} // namespace NDbFields

struct TKarma {
    std::optional<std::time_t> AllowUntil;
    std::uint32_t Value;
};

struct TKarmaStatus {
    std::uint32_t Value;
};

struct TUid {
    std::optional<bool> IsHosted;
    std::optional<std::string> Domain;
    std::optional<std::string> DomainEna;
    std::optional<bool> CatchAll;
    std::optional<std::string> Value;
};

using TAddressList = std::vector<TAddress>;
using TAttributeDict = std::unordered_map<std::string, std::string>;
using TDbFieldDict = std::unordered_map<std::string, std::optional<std::string>>;

struct TCommonUserInfo {
    std::optional<TAddressList> AddressList;
    std::optional<TAttributeDict> Attributes;
    std::optional<TDbFieldDict> DbFields;
    std::optional<TKarma> Karma;
    std::optional<TKarmaStatus> KarmaStatus;
    std::optional<TUid> Uid;
};

struct TUser: TCommonUserInfo {
};

using TUserList = std::vector<TUser>;

struct TUserInfoResponseData: TCommonResponse {
    std::optional<TUserList> Users;
};

struct TBruteforcePolicy {
    std::string Value;
};

struct TLoginResponseData: TCommonResponse, TCommonUserInfo {
    std::optional<TBruteforcePolicy> BruteforcePolicy;
    std::optional<std::string> Comment;
    std::optional<TStatus> LoginStatus;
    std::optional<TStatus> PasswordStatus;
    std::optional<TStatus> Status;
};

struct TOauth {
    std::string Scope;
};

struct TOauthResponseData: TCommonResponse, TCommonUserInfo {
    std::optional<TOauth> Oauth;
    std::optional<TStatus> Status;
};

using TErrorCode = boost::system::error_code;

template <typename TResponseData>
using TCallback = std::function<void(TErrorCode, TResponseData)>;

} // namespace NNwSmtp::NBlackBox::NClient
