#pragma once

#include <mail/nwsmtp/src/options.h>

#include <memory>

namespace NNwSmtp::NBlackBox {

using BlackBoxOpts = Options::BlackBoxOpts;

struct TConfig {
    explicit TConfig(
        BlackBoxOpts blackbox,
        bool corpListUse,
        bool authSettingsOptsUse
    )
        : Blackbox(std::move(blackbox))
        , CorpListUse(corpListUse)
        , AuthSettingsOptsUse(authSettingsOptsUse)
    { }

    BlackBoxOpts Blackbox;
    bool CorpListUse;
    bool AuthSettingsOptsUse;
};

using TConfigPtr = std::shared_ptr<TConfig>;

TConfigPtr MakeConfig(std::shared_ptr<Options> config);

} // namespace NNwSmtp::NBlackBox
