#pragma once

#include "client_types.h"
#include "config.h"

#include <mail/nwsmtp/src/auth.h>

#include <string>

namespace NNwSmtp::NBlackBox {

namespace NDetail {

struct TRequest {
    std::string Login;
    std::string UserIp;
    std::string Password;
    std::string OauthToken;
    std::string DbFields;
    std::string Attributes;

    static inline const std::string AuthType = "smtp";
    static inline const std::string Sid = "smtp";
    static inline const std::string Emails = "getdefault";
    static inline const std::string Format = "json";
};

} // namespace NDetail

class TRequest: public NDetail::TRequest {
public:
    NClient::THttpRequest BuildUserInfoRequest() const;
    NClient::THttpRequest BuildLoginRequest() const;
    NClient::THttpRequest BuildOauthRequest() const;
};

TRequest BuildUserInfoRequest(
    const std::string& login,
    const std::string& userip,
    bool allowList = false,
    bool getOrgId = false
);

TRequest BuildAuthRequest(TConfigPtr config, TAuthData authInfo);

} // namespace NNwSmtp::NBlackBox
