#pragma once

#include "client_types.h"

#include <cstdint>
#include <ctime>
#include <optional>
#include <set>
#include <string>

namespace NNwSmtp::NBlackBox {

struct TResponse {
    std::string Login;
    std::uint64_t Suid = 0;
    std::string Uid;
    std::string DefaultEmail;
    bool Hosted = false;
    bool CatchAll = false;
    std::string Domain;
    std::string Country;
    std::string OrgId;
    bool PhoneConfirmed = false;
    bool IsCorpList = false;
    bool IsMailList = false;
    bool IsBlocked = false;
    bool IsAssessor = false;
    bool HasPDDsid = false;
    bool AppPasswordEnabled = false;
    std::time_t RegistrationDate = 0;
    std::time_t BornDate = 0;
    std::string Mdb;
    std::uint32_t Karma = 0;
    std::uint32_t KarmaStatus = 0;
    std::time_t KarmaBanTime = 0;
    std::set<std::string> Scopes;

    bool AuthSuccess = false;
    std::string ErrorStr;
};

class TBaseResponse {
public:
    TResponse Result;

    explicit TBaseResponse(const NClient::TCommonResponse& responseData);
    const std::string& GetErrorMsg() const;

protected:
    void ParseUserInfo(const NClient::TCommonUserInfo& userInfo);

protected:
    std::string ErrorMsg;
};

class TInfoResponse : public TBaseResponse {
public:
    using TResponseData = NClient::TUserInfoResponseData;

    explicit TInfoResponse(const TResponseData& responseData);
};

class TLoginResponse : public TBaseResponse {
public:
    using TResponseData = NClient::TLoginResponseData;

    explicit TLoginResponse(const TResponseData& responseData);

    enum class EStatus {
        Valid,
        Disabled,
        Invalid,
        ShowCaptcha,
        AlienDomain,
        Compromised,
        Expired
    };

    enum class EAccountStatus {
        AccUnknown,
        AccValid,
        AccAlienDomain,
        AccNotFound,
        AccDisabled
    };

    enum class EPasswordStatus {
        PwdUnknown,
        PwdValid,
        PwdBad,
        PwdCompromised
    };
};

class TOAuthResponse : public TBaseResponse {
public:
    using TResponseData = NClient::TOauthResponseData;

    explicit TOAuthResponse(const TResponseData& responseData);

    enum class EStatus {
        Valid,
        NeedReset,
        Expired,
        NoAuth,
        Disabled,
        Invalid
    };
};

} // namespace NNwSmtp::NBlackBox
