#pragma once

#include <boost/lexical_cast.hpp>

#include <ctime>

namespace NNwSmtp::NBlackBox {

template <typename To, typename From, typename Target = std::remove_cvref_t<To>>
Target SafeCast(const From& from, To&& defValue) {
    Target result = Target();

    if (!boost::conversion::try_lexical_convert(from, result)) {
        result = std::forward<To>(defValue);
    }

    return result;
}

} // namespace NNwSmtp::NBlackBox
