#pragma once

#include "rcpt_context.h"

namespace NNwSmtp {

struct check
{
    typedef enum
    {
        CHK_ACCEPT      = 0,
        CHK_REJECT,
        CHK_TEMPFAIL,
        CHK_DISCARD

    } chk_status;

    chk_status m_result;
    std::string m_answer;

    std::string m_session_id;
    std::string m_remote_ip;

    static const char* status_to_string(chk_status status)
    {
        switch (status)
        {
        case CHK_ACCEPT:
            return "accept";
        case CHK_REJECT:
            return "reject";
        case CHK_TEMPFAIL:
            return "tempfail";
        case CHK_DISCARD:
            return "discard";
        }
    }
};

struct check_rcpt_t: public check {
    TRcptContext RcptContext;
};

struct check_data_t:
        public check
{
    check_data_t()
    {
    }

    std::string m_remote_host;
    std::string m_helo_host;
};

}   // namespace NNwSmtp

