#include "context.h"

namespace NNwSmtp {

TContext::TContext(
        std::string connectionId,
        std::string envelopeId,
        const std::string& clusterName,
        const std::string& hostName)
    : yplatform::task_context{connectionId + (envelopeId.empty() ? "" : ("-" + envelopeId))}
    , ConnectionId{std::move(connectionId)}
    , EnvelopeId{std::move(envelopeId)}
    , ClusterName(clusterName)
    , HostName(hostName) {
}

const std::string& TContext::GetConnectionId() const {
    return ConnectionId;
}

const std::string& TContext::GetEnvelopeId() const {
    return EnvelopeId;
}

const std::string& TContext::GetSessionId() const {
    return uniq_id();
}

const std::string& TContext::GetClusterName() const {
    return ClusterName;
}

const std::string& TContext::GetHostName() const {
    return HostName;
}

yplatform::task_context_ptr TContext::CreateTaskContext(std::string where) const {
    return boost::make_shared<yplatform::task_context>(
        GetSessionId() + (where.empty() ? "" : ("-" + std::move(where))));
}

} // namespace NNwSmtp
