#pragma once

#include <yplatform/task_context.h>

namespace NNwSmtp {

class TContext : public yplatform::task_context  {
public:
    TContext(std::string connectionId, std::string envelopeId, const std::string& clusterName, const std::string& hostName);

    const std::string& GetConnectionId() const;
    const std::string& GetEnvelopeId() const;
    const std::string& GetSessionId() const;
    const std::string& GetClusterName() const;
    const std::string& GetHostName() const;
    yplatform::task_context_ptr CreateTaskContext(std::string where = {}) const;

private:
    const std::string ConnectionId;
    const std::string EnvelopeId;
    const std::string ClusterName;
    const std::string HostName;
};

using TContextPtr = boost::shared_ptr<TContext>;

} // namespace NNwSmtp