#pragma once

#include "options.h"
#include "errors.h"
#include "types.h"

#include <mail/nwsmtp/src/blackbox/bb_checks_impl.h>
#include <mail/nwsmtp/src/blackbox/bb_client_impl.h>
#include <mail/nwsmtp/src/big_ml/client_impl.h>
#include <mail/nwsmtp/src/types.h>

#include <boost/asio.hpp>

namespace NNwSmtp::NControlFrom {

struct control_from : public std::enable_shared_from_this<control_from> {
    control_from(TContextPtr context, boost::asio::io_context& io)
        : context(context)
        , io(io)
    {
        auto blackboxClient = std::make_shared<NBlackBox::NClient::TClientImpl>(
            yplatform::find<yhttp::cluster_client, std::shared_ptr>("blackbox_client"),
            yplatform::find<ymod_tvm::tvm2_module, std::shared_ptr>("tvm"),
            io
        );
        bbChecks = std::make_shared<NBlackBox::TBBChecksImpl>(
            NBlackBox::MakeConfig(gconfig),
            std::move(blackboxClient)
        );
        bigMl = std::make_shared<NBigML::TClient>(
            gconfig->bigMlOpts,
            yplatform::find<ymod_httpclient::cluster_call, std::shared_ptr>("big_ml_client"),
            io
        );
    }

    void start(TRequest request, TCallback callback);

    static std::string parseEmail(const TBufferRange& value);

private:
    void handle_mailfrom_check(
        std::string mailfrom,
        TRequest request,
        TCallback callback,
        TErrorCode ec,
        NBlackBox::TResponse response
    );
    void handle_resolve_maillist(
        TRequest request,
        TCallback callback,
        TErrorCode ec,
        NBigML::TResponse response
    );

private:
    NBlackBox::TBBChecksPtr bbChecks;
    NBigML::TClientPtr bigMl;
    TContextPtr context;
    TBufferRange header;
    std::string mbodyEmail;
    boost::asio::io_context& io;
};

}  // namespace NNwSmtp::NControlFrom
