#include "errors.h"


namespace NNwSmtp::NControlFrom {

const char* TCategory::name() const noexcept {
    return "NNwSmtp::NControlFrom::TCategory";
}

std::string TCategory::message(int value) const {
    switch (static_cast<EError>(value)) {
        case EError::Accept:
            return "accept";
        case EError::Reject:
            return "reject";
        case EError::WhiteList:
            return "whitelist";
        case EError::Error:
            return "temporary error";
    }

    return "unknown error (" + std::to_string(value) + ")";
}

const boost::system::error_category& category() noexcept {
    static TCategory instance;
    return instance;
}

boost::system::error_code make_error_code(const EError error) {
    return {static_cast<int>(error), category()};
}

}  // namespace NNwSmtp::NControlFrom
