#pragma once

#include <boost/system/error_code.hpp>

namespace NNwSmtp::NControlFrom {

enum class EError {
    Accept = 0,
    Reject,
    WhiteList,
    Error
};

}  // NNwSmtp::NControlFrom

namespace boost {
namespace system {

template <>
struct is_error_code_enum<NNwSmtp::NControlFrom::EError> : std::true_type{};

}  // namespace system
}  // namespace boost

namespace NNwSmtp::NControlFrom {

class TCategory: public boost::system::error_category {
public:
    const char* name() const noexcept override;

    std::string message(int value) const override;
};

const boost::system::error_category& category() noexcept;

boost::system::error_code make_error_code(const EError code);

}  // NNwSmtp::NControlFrom
