#include "options.h"

#include <mail/nwsmtp/src/file_converter.h>

#include <boost/algorithm/string.hpp>
#include <boost/function_output_iterator.hpp>

#include <util/string/cast.h>


namespace NNwSmtp::NControlFrom {

void TOptions::Init(const yplatform::ptree& pt) {
    auto policy = pt.get<std::string>("policy");
    boost::to_lower(policy);
    if (!TryFromString<EPolicy>(policy, Policy)) {
        throw std::runtime_error("No such control_from policy: '" + policy + "'");
    }

    EnableWhiteList = pt.get<bool>("white_list.use", EnableWhiteList);

    if (EnableWhiteList) {
        TFileConverter::Copy(
            pt.get<std::string>("white_list.domains"),
            boost::make_function_output_iterator([&](auto domain) { WhiteList.AddDomain(domain); }));

        TFileConverter::Copy(
            pt.get<std::string>("white_list.uids"),
            boost::make_function_output_iterator([&](auto uid) { WhiteList.AddUid(uid); }));
    }
}

}  // namespace NNwSmtp::NControlFrom
