#include "async.h"
#include "async_impl.h"

#include <memory>

namespace NNwSmtp::NAsyncDlv {

void TAsyncDelivery::Run(
    TContextPtr context,
    TRequest dlvRequest,
    TCallback callback
) {
    auto impl = std::make_shared<TAsyncDeliveryImpl>(
        std::move(callback),
        std::move(context),
        std::move(dlvRequest),
        SmtpClient,
        SoClient,
        AvirCheckClient,
        Recognizer,
        YarmClient,
        Router,
        Io
    );

    boost::asio::post(Io, std::bind(&TAsyncDeliveryImpl::Run, std::move(impl), TErrorCode{}, std::string{}));
}

} // namespace NNwSmtp::NAsyncDlv
