#pragma once

#include "interface.h"
#include "types.h"

#include <mail/nwsmtp/src/avir/client.h>
#include <mail/nwsmtp/src/recognizer/recognizer.h>
#include <mail/nwsmtp/src/router/router.h>
#include <mail/nwsmtp/src/smtp_client/smtp_client.h>
#include <mail/nwsmtp/src/so/client.h>
#include <mail/nwsmtp/src/yarm/client.h>
#include <mail/nwsmtp/src/types.h>

#include <boost/asio.hpp>

namespace NNwSmtp::NAsyncDlv {

class TAsyncDelivery: public IAsyncDelivery {
public:
    TAsyncDelivery(
        SmtpClient::TSmtpClientPtr smtpClient,
        NSO::TSOClientPtr soClient,
        NAvir::TAvirCheckClientPtr avirCheckClient,
        TRecognizerPtr recognizer,
        NYarm::TClientPtr yarmClient,
        TRouterPtr router,
        boost::asio::io_context& io
    ) : SmtpClient(std::move(smtpClient))
      , SoClient(std::move(soClient))
      , AvirCheckClient(std::move(avirCheckClient))
      , Recognizer(std::move(recognizer))
      , YarmClient(std::move(yarmClient))
      , Router(std::move(router))
      , Io(io) {}

    void Run(
        TContextPtr context,
        TRequest dlvRequest,
        TCallback callback
    ) override;

private:
    SmtpClient::TSmtpClientPtr SmtpClient;
    NSO::TSOClientPtr SoClient;
    NAvir::TAvirCheckClientPtr AvirCheckClient;
    TRecognizerPtr Recognizer;
    NYarm::TClientPtr YarmClient;
    TRouterPtr Router;
    boost::asio::io_context& Io;
};

} // namespace NNwSmtp::NAsyncDlv
