#include "async_impl.h"

#include <boost/asio.hpp>

namespace NNwSmtp::NAsyncDlv {

#include <boost/asio/yield.hpp>

void TAsyncDeliveryImpl::Run(TErrorCode ec, std::string answer) {
    reenter(RunCoroutine) {
        yield PrepareHeaders();
        if (ec) {
            yield break;
        }

        yield PrepareDelivery();
        if (ec) {
            yield break;
        }

        yield Delivery();
        if (ec) {
            yield break;
        }
    }

    if (RunCoroutine.is_complete()) {
        LogAnalytics();
        Callback(std::move(ec), std::move(answer));
    }
}

#include <boost/asio/unyield.hpp>

} // namespace NNwSmtp::NAsyncDlv
