#include "async_impl.h"
#include "utils.h"

#include <mail/nwsmtp/src/utils.h>
#include <mail/nwsmtp/src/log.h>
#include <mail/nwsmtp/src/so/utils.h>

namespace NNwSmtp::NAsyncDlv {

void TAsyncDeliveryImpl::LogAnalytics() {
    const auto& envelope = DlvRequest.Envelope;
    const auto& sessionId = DlvRequest.SessionId;
    std::string labels = boost::join(envelope->so_labels_, ",");

    const auto xyHintParameters = GetNonpersonalHintsParameters(
        envelope->header_storage_->GetHeaders("x-yandex-hint")
    );
    const auto ipfrom = GetFirstValueInOrderOfAddition(xyHintParameters, "ipfrom");
    const auto smtpSessionId = GetFirstValueInOrderOfAddition(xyHintParameters, "session_id");
    const auto currentSessionId = str(boost::format("%1%-%2%") % sessionId % envelope->m_id);

    for (const auto& rcpt : envelope->m_rcpts) {
        LOGDOG_(glog->tskvAnalytics, notice,
            NLog::uniq_id=currentSessionId,
            NLog::connection_id=sessionId,
            NLog::envelope_id=envelope->m_id,
            NLog::cluster_name=gconfig->clusterName,
            NLog::host=gconfig->hostName,
            NLog::is_corp=is_corp(gconfig->clusterName),
            NLog::smtp_session=smtpSessionId.value_or(currentSessionId),
            NLog::from=envelope->m_sender,
            NLog::from_uid=envelope->m_sender_uid,
            NLog::remote_ip=ipfrom.value_or(DlvRequest.Ip.to_string()),
            NLog::rcpt=rcpt.m_name,
            NLog::rcpt_uid=rcpt.m_uid,
            NLog::inactive_for=rcpt.inactive_for_,
            NLog::message_id=envelope->message_id_,
            NLog::client=Mailer,
            NLog::x_request_id=RequestId,
            NLog::so_status=NSO::ResolutionToString(rcpt.m_spam_status),
            NLog::so_labels=labels,
            NLog::avir_status=avir_client::status_to_str(envelope->avirStatus),
            NLog::sent_status=check::status_to_string(rcpt.m_delivery_status),
            NLog::remote_answer=boost::trim_copy(rcpt.m_remote_answer),
            NLog::domain_type=std::to_string(rcpt.domainType),
            NLog::notify_mode=std::to_string(rcpt.m_notify_mode)
        );
    }
}

} // namespace NwSmtp::NAsyncDlv
