#pragma once

#include <mail/nwsmtp/src/types.h>
#include <mail/nwsmtp/src/so/types.h>
#include <mail/nwsmtp/src/recognizer/recognizer.h>

#include "envelope.h"

namespace NNwSmtp {

struct parsed_header_t {
    TBufferRange name;
    TBufferRange value;
    TBufferRange header;
};

using parsed_headers_t = std::vector<parsed_header_t>;

struct parse_header_parameters_t
{
    std::string from_domain;
    NSO::EResolution spam_status = NSO::EResolution::SO_RESOLUTION_SKIP;
    avir_client::status virus_status = avir_client::unknown;
    std::string request_id;
    bool captcha = false;
    std::string mailer_hdr_name;
    std::string mailer;
    std::size_t decycler_counter = 0;
};

struct parse_header_result_t
{
    parsed_headers_t headers;
    TBufferIterator body_iter;
    parse_header_parameters_t parameters;
};

parse_header_result_t ProcessHeaders (
    const envelope_ptr& envelope,
    TRecognizerPtr recognizer);
}
