#include "route_calculator.h"

#include <mail/nwsmtp/src/utils.h>

namespace NNwSmtp::NAsyncDlv {

#include <boost/asio/yield.hpp>

void RouteCalculator::Run(TErrorCode ec, Router::Response response) {
    reenter(Coro) {
        for (; RcptFirst != RcptLast; ++RcptFirst) {
            if (
                RcptFirst->m_delivery_status == check::CHK_REJECT ||
                RcptFirst->m_delivery_status == check::CHK_DISCARD ||
                RcptFirst->domainType != DomainType::UNKNOWN
            ) {
                continue;
            }
            yield {
                std::string local, domain;
                if (!parse_email(RcptFirst->m_name, local, domain)) {
                    continue;
                }
                Router->asyncRoute(Context, domain,
                    [this, self = shared_from_this()] (auto ec, auto response) {
                        boost::asio::post(Io, std::bind(&RouteCalculator::Run, self, ec, response));
                    }
                );
            }
            if(ec) {
                yield break;
            } else {
                RcptFirst->domainType = response.domainType;
            }
        }
    }
    if (Coro.is_complete()) {
        Callback(ec);
    }
}

#include <boost/asio/unyield.hpp>

} // namespace NNwSmtp::NAsyncDlv
