#pragma once

#include <mail/nwsmtp/src/envelope.h>
#include <mail/nwsmtp/src/router/router.h>
#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/types.h>

#include <boost/asio.hpp>

#include <functional>
#include <memory>

namespace NNwSmtp::NAsyncDlv {

struct RouteCalculator: public std::enable_shared_from_this<RouteCalculator> {

    using Iterator = envelope::rcpt_list_t::iterator;
    using TCallback = std::function<void(TErrorCode)>;
    using TRouterPtr = std::shared_ptr<Router>;

    RouteCalculator(
        TCallback callback,
        NNwSmtp::TContextPtr context,
        TRouterPtr router,
        Iterator first,
        Iterator last,
        boost::asio::io_context& io
    )
        : Callback(std::move(callback))
        , Context(std::move(context))
        , Router(std::move(router))
        , RcptFirst(std::move(first))
        , RcptLast(std::move(last))
        , Io(io) {}

    void Run(
        TErrorCode ec = TErrorCode {},
        Router::Response response = Router::Response {}
    );

    TCallback Callback;
    NNwSmtp::TContextPtr Context;
    TRouterPtr Router;
    boost::asio::coroutine Coro;

    Iterator RcptFirst;
    Iterator RcptLast;

    boost::asio::io_context& Io;
};

} // namespace NNwSmtp::NAsyncDlv
