#pragma once

#include "types.h"

#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/envelope.h>
#include <mail/nwsmtp/src/dmarc.h>
#include <mail/nwsmtp/src/rcpt.h>
#include <mail/nwsmtp/src/so/config.h>
#include <mail/nwsmtp/src/so/request.h>
#include <mail/nwsmtp/src/so/types.h>

#include <optional>
#include <vector>
#include <set>

namespace NNwSmtp::NAsyncDlv {

inline const std::string BAN_REASON_TYPE = "res_";
inline const std::string RFC_FAIL = "res_rfc_fail";
inline const std::string URL_RBL = "res_url_rbl";
inline const std::string BAD_KARMA = "res_bad_karma";
inline const std::string MAIL_LIMITS = "res_mail_limits";
inline const std::string PDD_ADMIN_KARMA = "res_pdd_admin_karma";
inline const std::string BOUNCES = "res_bounces";
inline const std::string SPAM_COMPL = "res_spam_compl";

NSO::TEmailInfo BuildMailFrom(const envelope_ptr& envelope);
std::vector<NSO::TEmailInfo> BuildRecipients(const envelope_ptr& envelope);

NSO::TRequestPtr BuildSoRequest(
    const TRequest& dlvRequest,
    const std::string& authResultsHeaderValue,
    dmarc::record::policy dmarcPolicy,
    const std::string& dmarcDomain,
    const NSO::TOptions& options
);

bool CheckInactivity(
    const TRcpt& rcpt,
    const std::set<std::string>& foundTypes,
    const NSO::TOptions& options
);

void CheckInactives(
    const NSO::TResponse& response,
    const envelope_ptr& envelope,
    const NSO::TOptions& options
);

TErrorCode GetMaliciousErrorCode(const std::vector<std::string>& soClasses);

std::pair<TErrorCode, std::string> MakeSoStatus(
    NSO::EResolution resolution,
    const std::vector<std::string>& soClasses,
    const std::string& dmarcDomain,
    const dmarc::record::policy& dmarcPolicy,
    const NSO::TOptions& options,
    bool captcha
);

void MakeSoPersonalStatus(const NSO::TResponse& response, const envelope_ptr& envelope);
std::string MakeUidStatusHeader(const NSO::TResponse& response, const envelope_ptr& envelope);
bool IsSpam(NSO::EResolution resolution);
std::string MakePersonalSpamHeader(const NSO::TResponse& response, const envelope_ptr& envelope);
std::string MakeSpamHeader(NSO::EResolution resolution);
std::string MakeForeignMx(const NSO::TResponse& response);
std::string FormatSoClasses(const NSO::TResponse& response);
std::string MakeSpamFlagHeader(NSO::EResolution resolution);
std::string MakeForeignMXHeader(std::string foreignMX);

std::pair<TErrorCode, std::string> MakeSoResult(
    const NSO::TResponse& response,
    const envelope_ptr& envelope,
    const std::string& dmarcDomain,
    const dmarc::record::policy& dmarcPolicy,
    const NSO::TOptions& options,
    bool captcha
);

void LogSoStatus(const TContextPtr& context, const envelope_ptr& envelope);

} // namespace NNwSmtp::NAsyncDlv
