#pragma once

#include "error_code.h"

#include <mail/nwsmtp/src/envelope.h>
#include <mail/nwsmtp/src/types.h>

#include <functional>
#include <memory>
#include <optional>

namespace NNwSmtp::NAsyncDlv {

struct TRequest {
    std::string HeloHost;
    std::string SessionId;
    std::string SmtpFrom;
    std::string RemoteHost;
    envelope_ptr Envelope;
    boost::asio::ip::address Ip;
    bool IsSSLNone;
    std::optional<std::string> SpfResult;
    std::optional<std::string> SpfExpl;
    std::time_t SessionStartTime;
};

using TCallback = std::function<void(TErrorCode, std::string)>;

} // namespace NNwSmtp::NAsyncDlv
