#pragma once

#include "types.h"

#include <mail/library/dsn/composer.hpp>

#include <mail/nwsmtp/src/dkim/adkim.h>
#include <mail/nwsmtp/src/options.h>

#include <mail/sova/include/nwsmtp/avir_client.h>

#include <vector>

namespace NNwSmtp::NAsyncDlv {

bool CanSendDsn(const envelope_ptr& envelope, std::int32_t mode);

SmtpPoint CheckSenderDependentRelayMap(const envelope_ptr& envelope, const std::string& smtpFrom);

envelope_ptr MakeDsnEnvelope(dsn::composer::type_t type, const envelope_ptr& env);

std::pair<TErrorCode, std::string> CalculateResponse(const envelope_ptr& envelope, bool dsn);

void RemoveHeaders(envelope_ptr& envelope);

std::pair<TErrorCode, std::string> ProcessAvirStatus(avir_client::status status);

TBufferRange GetMessageBodyRange(const envelope_ptr& envelope);
std::string GetMessageBody(const TBufferRange& messageBufferRange);

inline std::string GetMessageBody(const envelope_ptr& envelope) {
    return GetMessageBody(GetMessageBodyRange(envelope));
}

} // namespace NwSmtp::NAsyncDlv
