#pragma once

#include <mail/nwsmtp/src/options.h>
#include <mail/nwsmtp/src/utils.h>

#include <memory>

namespace NNwSmtp::NDlv {

struct TConfig {
    TConfig(
        TCaseInsensitiveHashSet removeHeaders,
        NSO::TOptions soOptions,
        std::unordered_set<std::string> trustHeaders,
        Options::DecyclerOpts decycler
    )
        : RemoveHeaders(std::move(removeHeaders))
        , SoOptions(std::move(soOptions))
        , TrustHeaders(std::move(trustHeaders))
        , Decycler(std::move(decycler)) {}

    TCaseInsensitiveHashSet RemoveHeaders;
    NSO::TOptions SoOptions;
    std::unordered_set<std::string> TrustHeaders;
    Options::DecyclerOpts Decycler;
};

using TConfigPtr = std::shared_ptr<TConfig>;

TConfigPtr MakeConfig(std::shared_ptr<Options> config);

} // namespace NNwSmtp::NDlv
