#pragma once

#include <boost/system/error_code.hpp>

namespace NNwSmtp::NDlv {

enum class EError {
    Ok = 0,
    BadMessage,
    NslsPermanentError,
    NslsTemporaryError,
    DuplicateFound,
    CycleDetected,
    Exception,
    MdsError,
    StorageMailNotFound,
    SOError,
    AvirError,
    Virus,
    Spam,
    Malicious,
    InvalidFid
};

}  // namespace NNwSmtp::NDlv

namespace boost {
namespace system {

template <>
struct is_error_code_enum<NNwSmtp::NDlv::EError> : std::true_type{};

}  // namespace system
}  // namespace boost

namespace NNwSmtp::NDlv {

class TCategory: public boost::system::error_category {
public:
    const char* name() const noexcept override;

    std::string message(int value) const override;

    bool equivalent(const boost::system::error_code& code, int condition) const noexcept override;
};

const boost::system::error_category& category() noexcept;

boost::system::error_code make_error_code(EError code);

boost::system::error_condition make_error_condition(EError ec);

}  // namespace NNwSmtp::NDlv
