#pragma once

#include "config.h"
#include "types.h"

#include <mail/nwsmtp/src/avir/client.h>
#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/header_storage.h>
#include <mail/nwsmtp/src/nsls/client.h>
#include <mail/nwsmtp/src/nsls/types.h>
#include <mail/nwsmtp/src/mds/client.h>
#include <mail/nwsmtp/src/resolver/client.h>
#include <mail/nwsmtp/src/so/client.h>
#include <mail/nwsmtp/src/types.h>

#include <yplatform/coroutine.h>

#include <optional>

namespace NNwSmtp::NDlv {

class TSyncDelivery {
public:
    using TYieldCtx = yplatform::yield_context<TSyncDelivery>;

    TSyncDelivery(
        TContextPtr context,
        const TOptions& options,
        const TEnvelopeInfo& envInfo,
        const TMailInfo& mailInfo,
        const TUserInfo& userInfo,
        TBuffer message,
        NNsls::TNslsClientPtr nslsClient,
        NMds::TMdsClientPtr mdsClient,
        NSO::TSOClientPtr soInClient,
        NSO::TSOClientPtr soOutClient,
        NDns::TResolverClientPtr resolverClient,
        NAvir::TAvirCheckClientPtr avirCheckClient,
        TConfigPtr config,
        TSyncResultCallback&& callback
    );

    void operator()(TYieldCtx yieldCtx);

private:
    void PrepareHeaders();
    void PutMessage(auto handler);
    void GetMessage(auto handler);
    void CheckSpam(auto handler);
    void ResolveIp(auto handler);
    void StoreMessage(auto handler);
    void CheckVirus(auto handler);

    TContextPtr Context;

    const TOptions Options;
    TEnvelopeInfo EnvInfo;
    const TMailInfo MailInfo;
    const TUserInfo UserInfo;
    TBuffer Message;

    NNsls::TNslsClientPtr NslsClient;
    NNsls::TResponse NslsResponse;
    NMds::TMdsClientPtr MdsClient;
    std::string Stid;
    NSO::TSOClientPtr SOInClient;
    NSO::TSOClientPtr SOOutClient;
    std::optional<NSO::TResponse> SoResponse;
    NDns::TResolverClientPtr ResolverClient;
    NAvir::TAvirCheckClientPtr AvirCheckClient;

    TConfigPtr Config;
    TSyncResultCallback Callback;

    THeaderStorage<TBufferRange> OriginalHeaders;
    THeaderStorage<TBufferRange> Headers;
    TBuffer AddedHeaders;
    TBufferRange Body;
    const bool IsSpam = false;
    TSyncResult Result;
    NAvir::TStatus AvirResult;
    TErrorCode ErrorCode;
    std::string RawMessage;
    bool CaptchaWasEntered = false;
    std::size_t DecyclerCounter = 1;
};

void RunSyncDelivery(
    TContextPtr context,
    const TEnvelopeInfo& EnvInfo,
    const TMailInfo& mailInfo,
    const TUserInfo& userInfo,
    const TOptions& options,
    TBuffer message,
    TSyncResultCallback&& callback
);

}  // namespace NNwSmtp::NDlv
